### 实验名称

实验9 Modbus网络通信实验

### 实验目的

1．使用VSPD虚拟串口软件创建串口连接

2．使用Modbus Poll、Modbus Slave仿真软件完成主站、从站的模拟

3．完成Modbus现场总线通信系统的组建

### 实验背景

物联网通信技术是指通过利用无线通信、传感器技术、云计算等手段，将各种智能设备、传感器和物理对象连接到互联网，实现设备之间的互联互通、数据采集和信息交换的技术。这一技术作为物联网的基础和关键技术之一，对于推动物联网的发展和应用具有重要意义。

### 建议课时

2课时

### 实验步骤

#### 步骤1：仿真软件的安装

软件安装的过程非常简单, 基本只需要点击下一步即可。

##### 1.安装VSPD

双击打开安装程序

![img](pic/204.jpg) 

点击OK，点击Next

选择"I accept the agreement", 点击Next；可以视情况选择修改软件安装位置。点击Next

![img](pic/205.jpg) 

点击Next；点击Install，等待软件安装完成

![img](pic/206.jpg) 

软件安装完成后，可以在桌面看到软件的图标。

##### 2.安装Modbus Poll仿真软件

仿真软件的安装与VSPD类似，这里仅展示安装过程截图:

 

![img](pic/207.jpg) 

 

![img](pic/208.jpg) 

之后一直点击Next，完成软件安装。软件安装完成后，桌面能看到软件的图标。

![img](pic/209.jpg) 

#### 步骤2：安装Modbus Slave仿真软件

![img](pic/210.jpg) 

 

![img](pic/211.jpg) 

之后一直点击Next，完成软件安装。软件安装完成后，桌面能看到软件的图标。

![img](pic/212.jpg) 

#### 步骤3：组建Modbus网络通信

##### 1.使用VSPD创建虚拟串口

双击桌面图标，打开串口模拟软件VSPD。软件界面如下:

![img](pic/213.jpg) 

点击创建端口对。之所以要创建一对，因为这里模拟的是一根线缆的两端，一端连接主机设备，另一端连接从机设备。

![img](pic/214.jpg) 

 

![img](pic/215.jpg) 

在 此电脑-->右键-->管理-->设备管理器->端口 中查看是否新加了两个虚拟端口:

![img](pic/216.jpg) 

##### 2.使用Modbus Slave创建一个Modbus从机

双击桌面Modbus Slave图标，软件界面如下:

![img](pic/217.jpg) 

点击 Connection -> Connect:

![img](pic/218.jpg) 

此时若软件未注册，会提示输入注册码。注册码可在软件压缩包中找到，粘贴后点击OK即可。

以下是创建连接的界面:

![img](pic/219.jpg) 

此时完成虚拟从机的创建。

##### 3.使用Modbus Poll创建一个Modbus主机

击桌面Modbus Poll图标打开软件，Poll软件界面与Slave软件基本一致。

点击Setup--Read/Write Definition...，确认参数设置。若有需要，可在设置界面修改Modbus的通信参数。

![img](pic/220.jpg) 

![img](pic/221.jpg) 

点击 Connection -> Connect， 若同样遇到注册码问题，请参考Modbus Slave的操作方式进行注册。

![img](pic/222.jpg) 

此时完成虚拟主机的创建。

##### 4.练习: 主机-从机通信操作

修改从机寄存器数据：

双击Modbus Slave软件界面值空白处

![img](pic/223.jpg) 

点击Display --> Communication, 可以看到通信记录:

![img](pic/224.jpg) 

![img](pic/225.jpg) 

Rx表示从机接收到的主机消息帧, 格式报文对应含义如下表:

| 01   | 03   | 00               | 00                   | 00         | 0A   | C5   | CD   |
| ---- | ---- | ---------------- | -------------------- | ---------- | ---- | ---- | ---- |
| 从站地址 | 功能码  | 读取的起始寄存器地址0x0000 | 查询的寄存器数量为0x000A(10)个 | 循环冗余校验 CRC |      |      |      |

Tx为从机发送到主机的回复报文，以类似方式组织:

从站地址 | 功能码 | 字节计数 | 字节1 | 字节N | 冗余校验

此时，查看Modbus Poll软件界面，发现寄存器0的值也变成了1。表示接收到了从机发过来的修改数据。

![img](pic/226.jpg) 

主机发送报文，从机接收到报文：

点击Modbus Poll软件界面，点击 Functions --> 06：Write Single Register

![img](pic/227.jpg) 

![img](pic/228.jpg) 

点击发送后，从机上对应地址的寄存器的值会变成发送的数据。

![img](pic/229.jpg) 

尝试通过主机发送不同的信息，修改从机上不同位置寄存器的值。

### 实验总结

通过本次Modbus Poll仿真软件的实验，我们可以对物联网通信的知识有更深地认识。